<?php
/**
 * Students Import
 *  1. Upload CSV or Excel file
 *  2. Associate CSV columns to Student Fields
 *  3. Import students / addresses / contacts
 *
 * @package Students Import module
 */

if ( file_exists( 'ProgramFunctions/SendNotifications.fnc.php' ) )
{
	require_once 'ProgramFunctions/SendNotifications.fnc.php';
}

// @deprecated since 6.1.
require_once 'modules/Students_Import/includes/SendNotifications.fnc.php';

require_once 'ProgramFunctions/FileUpload.fnc.php';

require_once 'modules/Students_Import/includes/StudentsImport.fnc.php';

require_once 'modules/Students_Import/includes/AddressesPeopleImport.fnc.php';

require_once 'modules/Students_Import/includes/StudentsUpdate.fnc.php';

DrawHeader( ProgramTitle() ); // Display main header with Module icon and Program title.

// Upload.
if ( $_REQUEST['modfunc'] === 'upload' )
{
	$error = array();

	if ( ! isset( $_SESSION['StudentsImport.php']['csv_file_path'] )
		|| ! $_SESSION['StudentsImport.php']['csv_file_path'] )
	{
		// Save original file name.
		$_SESSION['StudentsImport.php']['original_file_name'] = $_FILES['students-import-file']['name'];

		// Upload CSV file.
		$students_import_file_path = FileUpload(
			'students-import-file',
			sys_get_temp_dir() . DIRECTORY_SEPARATOR, // Temporary directory.
			array( '.csv', '.xls', '.xlsx' ),
			0,
			$error
		);

		if ( empty( $error ) )
		{
			// Convert Excel files to CSV.
			$csv_file_path = ConvertExcelToCSV( $students_import_file_path );

			// Open file.
			if ( ( fopen( $csv_file_path, 'r' ) ) === false )
			{
				$error[] = dgettext( 'Students_Import', 'Cannot open file.' );
			}
			else
			{
				$_SESSION['StudentsImport.php']['csv_file_path'] = $csv_file_path;
			}
		}
	}

	if ( $error )
	{
		if ( function_exists( 'RedirectURL' ) )
		{
			// @since 3.3.
			RedirectURL( 'modfunc' );
		}
		else
		{
			// @deprecated.
			unset( $_REQUEST['modfunc'] );
			unset( $_SESSION['_REQUEST_vars']['modfunc'] );
		}
	}
}
// Import.
elseif ( $_REQUEST['modfunc'] === 'import' )
{
	// Open file.
	if ( ! isset( $_SESSION['StudentsImport.php']['csv_file_path'] )
		|| fopen( $_SESSION['StudentsImport.php']['csv_file_path'], 'r' ) === false )
	{
		$error[] = dgettext( 'Students_Import', 'Cannot open file.' );
	}
	else
	{
		if ( $_REQUEST['mode'] === 'create' )
		{
			// Import students.
			$students_imported = CSVImport( $_SESSION['StudentsImport.php']['csv_file_path'] );

			$students_imported_txt = sprintf(
				dgettext( 'Students_Import', '%s students were imported.' ),
				$students_imported
			);
		}
		else
		{
			// Update students.
			$students_imported = CSVUpdate( $_SESSION['StudentsImport.php']['csv_file_path'] );

			$students_imported_txt = sprintf(
				dgettext( 'Students_Import', '%s students were updated.' ),
				$students_imported
			);
		}

		if ( $students_imported )
		{
			$note[] = button( 'check' ) . '&nbsp;' . $students_imported_txt;
		}
		else
		{
			$warning[] = $students_imported_txt;
		}

		// Remove CSV file.
		unlink( $_SESSION['StudentsImport.php']['csv_file_path'] );
	}

	if ( function_exists( 'RedirectURL' ) )
	{
		// @since 3.3.
		RedirectURL( 'modfunc' );
	}
	else
	{
		// @deprecated.
		unset( $_REQUEST['modfunc'] );
		unset( $_SESSION['_REQUEST_vars']['modfunc'] );
	}

	unset( $_SESSION['StudentsImport.php']['csv_file_path'] );
}

// Display error messages.
echo ErrorMessage( $error, 'error' );

// Display warnings.
echo ErrorMessage( $warning, 'warning' );

// Display note.
echo ErrorMessage( $note, 'note' );


if ( ! $_REQUEST['modfunc'] )
{
	/*if ( isset( $_SESSION['StudentsImport.php']['csv_file_path'] ) )
	{
		// Remove CSV file.
		@unlink( $_SESSION['StudentsImport.php']['csv_file_path'] );*/

		unset( $_SESSION['StudentsImport.php']['csv_file_path'] );
	//}

	// Form.
	echo '<form action="Modules.php?modname=' . $_REQUEST['modname'] .
		'&modfunc=upload" method="POST" enctype="multipart/form-data">';

	if ( AllowEdit( 'School_Setup/DatabaseBackup.php' ) )
	{
		DrawHeader( '<a href="Modules.php?modname=School_Setup/DatabaseBackup.php">' .
			_( 'Database Backup' ) . '</a>' );
	}

	DrawHeader( '<input type="file" name="students-import-file" accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" required title="' .
			sprintf( _( 'Maximum file size: %01.0fMb' ), FileUploadMaxSize() ) . '" />
		<span class="loading"></span>
		<br /><span class="legend-red">' . dgettext( 'Students_Import', 'Select CSV or Excel file' ) . '</span>' );

	// Create or Update students.
	$select_mode = SelectInput(
		'create',
		'mode',
		'<span class="a11y-hidden">' . dgettext( 'Students_Import', 'Mode' ) . '</span>',
		array(
			'create' => dgettext( 'Students_Import', 'Create Students' ),
			'update' => dgettext( 'Students_Import', 'Update Existing Students' ),
		),
		false,
		'',
		false
	);

	DrawHeader( $select_mode );

	echo '<br /><div class="center">' . SubmitButton( _( 'Submit' ) ) . '</div>';

	echo '</form>';
}
// Uploaded: show import form!
elseif ( $_REQUEST['modfunc'] === 'upload' )
{
	// Get CSV columns.
	$csv_columns = GetCSVColumns( $_SESSION['StudentsImport.php']['csv_file_path'] );

	if ( ! $csv_columns )
	{
		$error = array( 'No columns were found in the uploaded file.' );

		echo ErrorMessage( $error );
	}
	else
	{
		// Form.
		echo '<form action="Modules.php?modname=' . $_REQUEST['modname'] .
			'&modfunc=import&mode=' . $_REQUEST['mode'] .
			'" method="POST" class="import-students-form">';

		$rows_number = file( $_SESSION['StudentsImport.php']['csv_file_path'] );

		$rows_number = count( $rows_number );

		$submit_text = $_REQUEST['mode'] === 'update' ?
			dgettext( 'Students_Import', 'Update Existing Students' ) :
			dgettext( 'Students_Import', 'Create Students' );

		DrawHeader(
			$_SESSION['StudentsImport.php']['original_file_name'] . ': ' .
				sprintf( dgettext( 'Students_Import', '%s rows' ), $rows_number ),
			SubmitButton(
				$submit_text,
				'',
				' class="button-primary import-students-button"'
			)
		);
		?>
		<script>
		$(function(){
			$('.import-students-form').submit(function(e){

				e.preventDefault();

				var alertTxt = <?php echo json_encode( dgettext(
						'Students_Import',
						'Are you absolutely ready to import students? Make sure you have backed up your database!'
					) ); ?>;

				// Alert.
				if ( ! window.confirm( alertTxt ) ) return false;

				var $buttons = $('.import-students-button'),
					buttonTxt = $buttons.val(),
					seconds = 5,
					stopButtonHTML = <?php echo json_encode( SubmitButton(
						dgettext( 'Students_Import', 'Stop' ),
						'',
						'class="stop-button"'
					) ); ?>;

				$buttons.css('pointer-events', 'none').attr('disabled', true).val( buttonTxt + ' ... ' + seconds );

				var countdown = setInterval( function(){
					if ( seconds == 0 ) {
						clearInterval( countdown );
						$('.import-students-form').off('submit').submit();
						return;
					}

					$buttons.val( buttonTxt + ' ... ' + --seconds );
				}, 1000 );

				// Insert stop button.
				$( stopButtonHTML ).click( function(){
					clearInterval( countdown );
					$('.stop-button').remove();
					$buttons.css('pointer-events', '').attr('disabled', false).val( buttonTxt );
					return false;
				}).insertAfter( $buttons );
			});
		});
		</script>
		<?php

		// Import first row? (generally column names).
		DrawHeader(
			CheckboxInput(
				'',
				'import-first-row',
				dgettext( 'Students_Import', 'Import first row' ),
				'',
				true
			),
			'<a href="Modules.php?modname=' . $_REQUEST['modname'] . '&modfunc=upload&mode=' . $_REQUEST['mode'] . '">' .
				dgettext( 'Students_Import', 'Reset form' ) . '</a>'
		);

		$add_address_contact = '';

		if ( $_REQUEST['mode'] === 'create' )
		{
			// Add Student's Address, replaced with Add Contact onclick.
			$add_address_contact = '<a href="#" onclick="addStudentAddress(this); return false;">' .
				button( 'add' ) .
				'<b>' . dgettext( 'Students_Import', 'Add Student\'s Address' ) . '</b></a>
			<a href="#" onclick="addContact(); return false;" id="add-contact-link" style="display: none;">' .
				button( 'add' ) .
				'<b>' . dgettext( 'Students_Import', 'Add Contact' ) . '</b></a>';
		}

		// Premium: Custom date format (update tooltips on change), may be necessary for Japan: YY-MM-DD?
		// Premium: Custom checkbox checked format (update tooltips on change).
		DrawHeader(
			dgettext( 'Students_Import', 'Checkbox fields checked state' ) . ': ' .
			TextInput(
				'Y',
				'checkbox-checked-state',
				'',
				'size="5" onblur="updateCheckboxFieldsTooltip(this);"',
				false
			),
			$add_address_contact
		);

		?>
		<script>
			var checkboxCheckedStateVal = 'Y';

			function updateCheckboxFieldsTooltip(el) {

				var currentVal = el.value;

				if ( currentVal != checkboxCheckedStateVal ) {

					$('.custom-checkbox-format').html(currentVal);

					checkboxCheckedStateVal = currentVal;
				}
			}
		</script>
		<?php

		echo '<br /><div class="st">';

		echo '<table class="widefat cellspacing-0 center">';

		if ( $_REQUEST['mode'] === 'update' )
		{
			// Identify Student by ID or Username or Name.
			?>
			<script>
				var gradesImportIdentifyStudent = function( withId ) {
					var withIds = ['STUDENT_ID', 'USERNAME', 'NAME'];

					for ( max = withIds.length, i = 0; i < max; i++ ) {
						if ( withIds[ i ] === withId ) {
							$( '#' + withIds[ i ] ).show().css('position', 'relative').css('top', 'auto');

							// Enable select & update chosen.
							$( '#' + withIds[ i ] ).find('select').prop('disabled', false).trigger("chosen:updated");

							continue;
						}

						$( '#' + withIds[ i ] ).hide();

						// Disable select & update chosen.
						$( '#' + withIds[ i ] ).find('select').prop('disabled', true).trigger("chosen:updated");
					}
				};
			</script>
			<?php
			$student_identify_options = array(
				'STUDENT_ID' => sprintf( _( '%s ID' ), Config( 'NAME' ) ),
				'USERNAME' => _( 'Username' ),
				'NAME' => _( 'Name' ),
			);

			echo '<tr><td>' . SelectInput(
				'STUDENT_ID',
				'student_identify',
				dgettext( 'Grades_Import', 'Identify Student' ),
				$student_identify_options,
				false,
				'autocomplete="off" onchange="gradesImportIdentifyStudent(this.options[selectedIndex].value);"',
				false
			) . '</td></tr>';

			echo '<tr id="STUDENT_ID"><td>' .
				_makeSelectInput( 'STUDENT_ID', $csv_columns, sprintf( _( '%s ID' ), Config( 'NAME' ) ), 'required' ) .
			'</td></tr>';

			echo '<tr id="USERNAME" style="position: absolute; top: -1000px"><td>' .
				_makeSelectInput( 'USERNAME', $csv_columns, _( 'Username' ), 'required disabled' ) .
			'</td></tr>';

			echo '<tbody id="NAME" class="width-100p" style="position: absolute; top: -1000px"><tr><td>' .
				_makeSelectInput( 'FIRST_NAME', $csv_columns, _( 'First Name' ), 'required disabled' ) .
			'</td></tr>';

			echo '<tr><td>' .
				_makeSelectInput( 'LAST_NAME', $csv_columns, _( 'Last Name' ), 'required disabled' ) .
			'</td></tr></tbody>';
		}
		elseif ( $_REQUEST['mode'] === 'create' )
		{
			/**
			 * Student Fields.
			 */
			echo '<tr><td><h4>' . _( 'Student Fields' ) . '</h4></td></tr>';

			echo '<tr><td>' .
				_makeSelectInput( 'FIRST_NAME', $csv_columns,  _( 'First Name' ), 'required' ) .
			'</td></tr>';

			echo '<tr><td>' .
				_makeSelectInput( 'MIDDLE_NAME', $csv_columns, _( 'Middle Name' ) ) .
			'</td></tr>';

			echo '<tr><td>' .
				_makeSelectInput( 'LAST_NAME', $csv_columns, _( 'Last Name' ), 'required' ) .
			'</td></tr>';

			$tooltip = _makeFieldTypeTooltip(
				'numeric',
				'; ' . dgettext( 'Students_Import', 'IDs are automatically generated if you select "N/A".' )
			);

			echo '<tr><td>' .
				_makeSelectInput( 'STUDENT_ID', $csv_columns, sprintf( _( '%s ID' ), Config( 'NAME' ) ) . $tooltip ) .
			'</td></tr>';

			// Premium: generic username (Student ID).
			$csv_columns_generic = array(
					'generic' => sprintf( dgettext( 'Students_Import', 'Generic: %s' ), sprintf( _( '%s ID' ), Config( 'NAME' ) ) )
				) +	$csv_columns;

			echo '<tr><td>' .
				_makeSelectInput( 'USERNAME', $csv_columns_generic, _( 'Username' ) ) .
			'</td></tr>';

			// Premium: generic password ([username]*123).
			$csv_columns_generic = array(
					'generic' => sprintf(
						dgettext( 'Students_Import', 'Generic: %s' ),
						_( 'Username' ) . ' + ' . dgettext( 'Students_Import', 'extra' ) . ':'
					)
				) +	$csv_columns;

			echo '<tr><td>' .
				_makeSelectInput( 'PASSWORD', $csv_columns_generic, _( 'Password' ), 'onchange="passwordFieldGeneric(this); return false;"' );

			$password_generic_extra_field = TextInput(
				'',
				'password-generic-extra',
				dgettext( 'Students_Import', 'Append to Generic Password' )
			);
			?>
			<script>
			function passwordFieldGeneric( field ) {
				if ( field.value === 'generic' ) {

					var extraField = <?php echo json_encode( '<div id="password-generic-extra-wrapper">' .
						$password_generic_extra_field . '</div>' ); ?>;

					// Add Exra Field after Password input.
					$( field ).parents( 'td' ).append( extraField );
				} else {

					// Remove Password Generic Extra Field.
					$( '#password-generic-extra-wrapper' ).remove();
				}
			}
			</script>
			<?php
			echo '</td></tr>';
		}

		/**
		 * Custom Student Fields.
		 */
		$fields_RET = DBGet( DBQuery( "SELECT cf.ID,cf.TITLE,cf.TYPE,cf.SELECT_OPTIONS,
			cf.REQUIRED,cf.CATEGORY_ID,sfc.TITLE AS CATEGORY_TITLE
			FROM CUSTOM_FIELDS cf, STUDENT_FIELD_CATEGORIES sfc
			WHERE cf.CATEGORY_ID=sfc.ID
			AND cf.TYPE<>'files'
			ORDER BY sfc.SORT_ORDER, cf.SORT_ORDER") );

		$category_id_last = 0;

		foreach ( (array) $fields_RET as $field )
		{
			if ( $category_id_last !== $field['CATEGORY_ID'] )
			{
				// Add Category name as Student Fields separator!
				echo '<tr><td><h4>' . ParseMLField( $field['CATEGORY_TITLE'] ) . '</h4></td></tr>';
			}

			$category_id_last = $field['CATEGORY_ID'];

			$tooltip = _makeFieldTypeTooltip( $field['TYPE'] );

			echo '<tr><td>' .
				_makeSelectInput(
					'CUSTOM_' . $field['ID'],
					$csv_columns,
					ParseMLField( $field['TITLE'] ) . $tooltip,
					$field['REQUIRED'] && $_REQUEST['mode'] === 'create' ? 'required' : ''
				) .
			'</td></tr>';
		}


		if ( $_REQUEST['mode'] === 'create' )
		{
			/**
			 * Enrollment.
			 */
			echo '<tr><td><h4>' . _( 'Enrollment' ) . '</h4></td></tr>';

			$gradelevels_RET = DBGet( DBQuery( "SELECT ID,TITLE
				FROM SCHOOL_GRADELEVELS
				WHERE SCHOOL_ID='" . UserSchool() . "'
				ORDER BY SORT_ORDER" ) );

			$options = array();

			foreach ( (array) $gradelevels_RET as $gradelevel )
			{
				// Add 'ID_' prefix not to mix with CSV columns.
				$options[ 'ID_' . $gradelevel['ID'] ] = $gradelevel['TITLE'];
			}

			// Add CSV columns to set Grade Level.
			$options += $csv_columns;

			echo '<tr><td>' .
				_makeSelectInput( 'GRADE_ID', $options, _( 'Grade Level' ), 'required', true ) .
			'</td></tr>';

			$calendars_RET = DBGet( DBQuery( "SELECT CALENDAR_ID,DEFAULT_CALENDAR,TITLE
				FROM ATTENDANCE_CALENDARS
				WHERE SYEAR='" . UserSyear() . "'
				AND SCHOOL_ID='" . UserSchool() . "'
				ORDER BY DEFAULT_CALENDAR ASC" ) );

			$options = array();

			foreach ( (array) $calendars_RET as $calendar )
			{
				$options[ $calendar['CALENDAR_ID'] ] = $calendar['TITLE'];

				if ( $calendar['DEFAULT_CALENDAR'] )
				{
					$options[ $calendar['CALENDAR_ID'] ] .= ' (' . _( 'Default' ) . ')';
				}
			}

			$no_chosen = false;

			echo '<tr><td>' .
				_makeSelectInput(
					'CALENDAR_ID',
					$options,
					_( 'Calendar' ),
					'required',
					$no_chosen,
					'enrollment'
				) .
			'</td></tr>';

			$schools_RET = DBGet( DBQuery( "SELECT ID,TITLE
				FROM SCHOOLS
				WHERE ID!='" . UserSchool() . "'
				AND SYEAR='" . UserSyear() . "'" ) );

			$options = array(
				UserSchool() => _( 'Next grade at current school' ),
				'0' => _( 'Retain' ),
				'-1' => _( 'Do not enroll after this school year' ),
			);

			foreach ( (array) $schools_RET as $school )
			{
				$options[ $school['ID'] ] = $school['TITLE'];
			}

			echo '<tr><td>' .
				_makeSelectInput(
					'NEXT_SCHOOL',
					$options,
					_( 'Rolling / Retention Options' ),
					'required',
					$no_chosen,
					'enrollment'
			) .
			'</td></tr>';

			$enrollment_codes_RET = DBGet( DBQuery( "SELECT ID,TITLE AS TITLE
				FROM STUDENT_ENROLLMENT_CODES
				WHERE SYEAR='" . UserSyear() . "'
				AND TYPE='Add'
				ORDER BY SORT_ORDER" ) );

			$options = array();

			foreach ( (array) $enrollment_codes_RET as $enrollment_code )
			{
				$options[ $enrollment_code['ID'] ] = $enrollment_code['TITLE'];
			}

			echo '<tr><td>' .
				_makeDateInput( 'START_DATE', '', true, 'enrollment' ) . ' -<br />' .
				_makeSelectInput(
					'ENROLLMENT_CODE',
					$options,
					_( 'Attendance Start Date this School Year' )
						. '<div class="tooltip"><i>' .
						dgettext( 'Students_Import', 'If the date is left empty, students will not be enrolled (inactive).' ) .
						'</i></div>',
					'',
					$no_chosen,
					'enrollment'
				) .
			'</td></tr>';

			if ( Config( 'STUDENTS_EMAIL_FIELD' ) )
			{
				$tooltip = '<div class="tooltip"><i>' . dgettext(
					'Students_Import',
					'Notifications are sent if Username, Password, Email Address are set and Attendance Start Date this School Year is on or before today.'
				) . '</i></div>';

				echo '<tr><td>' . CheckboxInput(
					'',
					'send_notification',
					dgettext( 'Students_Import', 'Send email notification to Students' ) . $tooltip,
					'',
					true,
					'Yes',
					'No',
					false,
					'disabled'
				) . '</td></tr>';

				$student_email_field = Config( 'STUDENTS_EMAIL_FIELD' ) === 'USERNAME' ?
					'USERNAME' : 'CUSTOM_' . Config( 'STUDENTS_EMAIL_FIELD' );

				// Enable Send Notification checkbox only if:
				// Username, Password, Email Address set & Attendance Start Date this School Year <= today.
				?>
				<script>
					var SendNotificationEnable = function() {
						var month = $('select[name="month_enrollment[START_DATE]"]').val(),
							day = $('select[name="day_enrollment[START_DATE]"]').val(),
							year = $('select[name="year_enrollment[START_DATE]"]').val();

						if ( $('#valuesUSERNAME').val()
							&& $('#valuesPASSWORD').val()
							&& $('#values' + <?php echo json_encode( $student_email_field ); ?>).val()
							&& month && month <= <?php echo json_encode( date( 'm' ) ); ?>
							&& day && day <= <?php echo json_encode( date( 'd' ) ); ?>
							&& year && year <= <?php echo json_encode( date( 'Y' ) ); ?> ) {
							$('#send_notification').prop( 'disabled', false );

							for( i=0; i<3; i++ ) {
								// Highlight effect.
								$('#send_notification').parent('label').fadeTo('slow', 0.5).fadeTo('slow', 1.0);
							}

							return;
						}

						$('#send_notification').prop( 'disabled', true );
					};

					$(document).ready(function(){
						$('#valuesUSERNAME').change(SendNotificationEnable);
						$('#valuesPASSWORD').change(SendNotificationEnable);
						$('#values' + <?php echo json_encode( $student_email_field ); ?>).change(SendNotificationEnable);
						$('select[name="month_enrollment[START_DATE]"]').change(SendNotificationEnable);
						$('select[name="day_enrollment[START_DATE]"]').change(SendNotificationEnable);
						$('select[name="year_enrollment[START_DATE]"]').change(SendNotificationEnable);
					});
				</script>
				<?php
			}

			if ( ! empty( $RosarioPlugins['Moodle'] )
				&& function_exists( 'MoodleConfig' )
				&& MoodleConfig()
				&& Config( 'STUDENTS_EMAIL_FIELD' ) )
			{
				$tooltip = '<div class="tooltip"><i>' . dgettext(
					'Students_Import',
					'LMS will create a password and send an email to user. Account is created in LMS only if Username and Email Address are set.'
				) . '</i></div>';

				echo '<tr><td>' . CheckboxInput(
					'',
					'moodle_create_student',
					_( 'Create Student in LMS' ) . $tooltip,
					'',
					true,
					'Yes',
					'No',
					false,
					'disabled'
				) . '</td></tr>';

				$student_email_field = Config( 'STUDENTS_EMAIL_FIELD' ) === 'USERNAME' ?
					'USERNAME' : 'CUSTOM_' . Config( 'STUDENTS_EMAIL_FIELD' );

				// Enable Create Student in LMS checkbox only if:
				// Username, Email Address set.
				?>
				<script>
					var MoodleCreateStudentEnable = function() {
						if ( $('#valuesUSERNAME').val()
							&& $('#values' + <?php echo json_encode( $student_email_field ); ?>).val() ) {
							$('#moodle_create_student').prop( 'disabled', false );

							for( i=0; i<3; i++ ) {
								// Highlight effect.
								$('#moodle_create_student').parent('label').fadeTo('slow', 0.5).fadeTo('slow', 1.0);
							}

							return;
						}

						$('#moodle_create_student').prop( 'disabled', true );
					};

					$(document).ready(function(){
						$('#valuesUSERNAME').change(MoodleCreateStudentEnable);
						$('#values' + <?php echo json_encode( $student_email_field ); ?>).change(MoodleCreateStudentEnable);
					});
				</script>
				<?php
			}
		}

		echo '</table>';

		echo '</div><div class="st" id="addresses-people-td">';

		// Addresses & People form.
		AddressesPeopleForm();

		echo '</div>';

		echo '<br style="clear: both;" /><div class="center">' . SubmitButton(
			$submit_text,
			'',
			' class="button-primary import-students-button"'
		) . '</div></form>';
	}
}
