<?php
/**
 * French Help texts
 *
 * Texts are organized by:
 * - Module
 * - Profile
 *
 * Please use this file as a model to translate the texts to your language
 * The new resulting Help file should be named after the following convention:
 * Help_[two letters language code].php
 *
 * @author François Jacquet
 *
 * @uses Heredoc syntax
 * @see  http://php.net/manual/en/language.types.string.php#language.types.string.syntax.heredoc
 *
 * @package Grades Import module
 * @subpackage Help
 */

// STAFF AND PARENTS IMPORT ---.
if ( User( 'PROFILE' ) === 'admin' ) :

	$help['Users/TeacherPrograms.php&include=Grades_Import/GradebookGradesImport.php'] = <<<HTML
<p>
	<i>Programmes Enseignants: Importer Notes</i> vous permet l'import de notes (du Carnet) contenues dans un fichier <b>Excel</b> ou <b>CSV</b>.
</p>
<p>
	Vous pouvez sélectionner les classes de l'enseignant en utilisant le menu déroulant du coin supérieur gauche de la page.
</p>
<p>
	D'abord, il est recommandé procéder à un <b>backup de la base de données</b> au cas ou surviendrai de problème.
</p>
<p>
	Premièrement, sélectionnez le fichier Excel (.xls, .xlsx) ou CSV (.csv) qui contient les Notes des élèves à l'aide du champ "Sélectionner fichier CSV ou Excel".
	Ensuite, appuyez sur le bouton "Valider" pour uploader le fichier.
	Si vous sélectionnez un fichier Excel, seule la première feuille de calcul sera uploadée.
</p>
<p>
	Sur l'écran suivant, vous pourrez associer les colonnes contenant des notes (ou points) à chaque Devoir.
	Identifiez les Élèves inscrit à la Classe grâce à leur ID, ou Nom Utilisateur, ou Prénom et Nom de Famille.
	Notez s'il vous plaît que les champs en <span style="color:red;">rouge</span> sont obligatoires.
	Cochez la case "Importer la première ligne" en haut de l'écran si la première ligne du fichier contient des infos au lieu de noms de colonnes.
	Une fois prêt, appuyez sur le bouton "Importer Notes du Carnet".
</p>

HTML;

endif;


if ( User( 'PROFILE' ) === 'teacher' ) :

	$help['Grades_Import/GradebookGradesImport.php'] = <<<HTML
<p>
	<i>Importer Notes</i> vous permet l'import de notes (du Carnet) contenues dans un fichier <b>Excel</b> ou <b>CSV</b>.
</p>
<p>
	Vous pouvez sélectionner la classe souhaitée en utilisant le menu déroulant du menu à gauche de la page.
</p>
<p>
	Premièrement, sélectionnez le fichier Excel (.xls, .xlsx) ou CSV (.csv) qui contient les Notes des élèves à l'aide du champ "Sélectionner fichier CSV ou Excel".
	Ensuite, appuyez sur le bouton "Valider" pour uploader le fichier.
	Si vous sélectionnez un fichier Excel, seule la première feuille de calcul sera uploadée.
</p>
<p>
	Sur l'écran suivant, vous pourrez associer les colonnes contenant des notes (ou points) à chaque Devoir.
	Identifiez les Élèves inscrit à la Classe grâce à leur ID, ou Nom Utilisateur, ou Prénom et Nom de Famille.
	Notez s'il vous plaît que les champs en <span style="color:red;">rouge</span> sont obligatoires.
	Cochez la case "Importer la première ligne" en haut de l'écran si la première ligne du fichier contient des infos au lieu de noms de colonnes.
	Une fois prêt, appuyez sur le bouton "Importer Notes du Carnet".
</p>

HTML;

endif;
