<?php
/**
 * Spanish Help texts
 *
 * Texts are organized by:
 * - Module
 * - Profile
 *
 * Please use this file as a model to translate the texts to your language
 * The new resulting Help file should be named after the following convention:
 * Help_[two letters language code].php
 *
 * @author François Jacquet
 *
 * @uses Heredoc syntax
 * @see  http://php.net/manual/en/language.types.string.php#language.types.string.syntax.heredoc
 *
 * @package Grades Import module
 * @subpackage Help
 */

// STAFF AND PARENTS IMPORT ---.
if ( User( 'PROFILE' ) === 'admin' ) :

	$help['Users/TeacherPrograms.php&include=Grades_Import/GradebookGradesImport.php'] = <<<HTML
<p>
	<i>Programas Docentes: Importar Calificaciones</i> le permite importar calificaciones (del Libro) contenidas en un archivo <b>Excel</b> o <b>CSV</b>.
</p>
<p>
	Se pueden seleccionar las clases del docente usando el menú desplegable de clases en la parte superior de la página.
</p>
<p>
	Primero, se recomienda proceder a un <b>backup de la base de datos</b> en casos de falla.
</p>
<p>
	Primero, seleccione el archivo Excel (.xls, .xlsx) o CSV (.csv) que contiene las Calificaciones de los estudiantes usando el campo "Seleccionar archivo CSV o Excel".
	Luego, presione el botón "Enviar" para subir el archivo.
	Por favor note que si selecciona un archivo Excel, solamente la primera hoja de cálculo está subida.
</p>
<p>
	En la pantalla siguiente, podrá asociar las columnas que contienen calificaciones (o puntos) a cada Tarea.
	Identifique los Estudiantes inscritos a la Clase basado en sus ID, o Nombre de usuario, o Nombre y Apellido.
	Por favor nota que los campos en <span style="color:red;">rojo</span> son obligatorios.
	Marque la casilla "Importar la primera línea" arriba en la pantalla si la primera línea del archivo contiene datos en vez de los nombres de las columnas.
	Una vez listo, haga clic en el botón "Importar Calificaciones del Libro".
</p>

HTML;

endif;


if ( User( 'PROFILE' ) === 'teacher' ) :

	$help['Grades_Import/GradebookGradesImport.php'] = <<<HTML
<p>
	<i>Importar Calificaciones</i> le permite importar calificaciones (del Libro) contenidas en un archivo <b>Excel</b> o <b>CSV</b>.
</p>
<p>
	Se puede seleccionar la clase deseada usando el menú desplegable de clases en el menú de izquierda.
</p>
<p>
	Primero, seleccione el archivo Excel (.xls, .xlsx) o CSV (.csv) que contiene las Calificaciones de los estudiantes usando el campo "Seleccionar archivo CSV o Excel".
	Luego, presione el botón "Enviar" para subir el archivo.
	Por favor note que si selecciona un archivo Excel, solamente la primera hoja de cálculo está subida.
</p>
<p>
	En la pantalla siguiente, podrá asociar las columnas que contienen calificaciones (o puntos) a cada Tarea.
	Identifique los Estudiantes inscritos a la Clase basado en sus ID, o Nombre de usuario, o Nombre y Appellido.
	Por favor nota que los campos en <span style="color:red;">rojo</span> son obligatorios.
	Marque la casilla "Importar la primera línea" arriba en la pantalla si la primera línea del archivo contiene datos en vez de los nombres de las columnas.
	Una vez listo, haga clic en el botón "Importar Calificaciones del Libro".
</p>

HTML;

endif;
