<?php
/**
 * English Help texts
 *
 * Texts are organized by:
 * - Module
 * - Profile
 *
 * Please use this file as a model to translate the texts to your language
 * The new resulting Help file should be named after the following convention:
 * Help_[two letters language code].php
 *
 * @author François Jacquet
 *
 * @uses Heredoc syntax
 * @see  http://php.net/manual/en/language.types.string.php#language.types.string.syntax.heredoc
 *
 * @package Grades Import module
 * @subpackage Help
 */

// STAFF AND PARENTS IMPORT ---.
if ( User( 'PROFILE' ) === 'admin' ) :

	$help['Users/TeacherPrograms.php&include=Grades_Import/GradebookGradesImport.php'] = <<<HTML
<p>
	<i>Teacher Programs: Import Grades</i> allows you to import (Gradebook) grades contained in an <b>Excel</b> spreadsheet or a <b>CSV</b> file.
</p>
<p>
	You can select the teachers classes using the course period pull-down in the upper left corner of the page.
</p>
<p>
	First thing, it is recommended to <b>backup your database</b> in case something goes wrong.
</p>
<p>
	First, select the Excel (.xls, .xlsx) or CSV (.csv) file containing the student Grades using the "Select CSV or Excel file".
	Then, click the "Submit" button to upload the file.
	Please note that if you select an Excel file, only the first spreadsheet will be uploaded.
</p>
<p>
	On the next screen, you will be able to associate columns containing grades (or points) to each Assignment.
	Identify Students enrolled in the Course Period based on their Student ID, or Username, or First and Last Names.
	Please note that the fields in <span style="color:red;">red</span> are mandatory.
	Check the "Import first row" checkbox at the top of the screen if your file's first row contains data instead of column labels.
	Once you are set, click the "Import Gradebook Grades" button.
</p>

HTML;

endif;


if ( User( 'PROFILE' ) === 'teacher' ) :

	$help['Grades_Import/GradebookGradesImport.php'] = <<<HTML
<p>
	<i>Import Grades</i> allows you to import (Gradebook) grades contained in an <b>Excel</b> spreadsheet or a <b>CSV</b> file.
</p>
<p>
	You can select the desired class using the course period pull-down in the left menu.
</p>
<p>
	First, select the Excel (.xls, .xlsx) or CSV (.csv) file containing the student Grades using the "Select CSV or Excel file".
	Then, click the "Submit" button to upload the file.
	Please note that if you select an Excel file, only the first spreadsheet will be uploaded.
</p>
<p>
	On the next screen, you will be able to associate columns containing grades (or points) to each Assignment.
	Identify Students enrolled in the Course Period based on their Student ID, or Username, or First and Last Names.
	Please note that the fields in <span style="color:red;">red</span> are mandatory.
	Check the "Import first row" checkbox at the top of the screen if your file's first row contains data instead of column labels.
	Once you are set, click the "Import Gradebook Grades" button.
</p>

HTML;

endif;
